import{AnimationClip,Bone,Box3,BufferAttribute,BufferGeometry,ClampToEdgeWrapping,Color,ColorManagement,DirectionalLight,DoubleSide,FileLoader,FrontSide,Group,ImageBitmapLoader,InstancedMesh,InterleavedBuffer,InterleavedBufferAttribute,Interpolant,InterpolateDiscrete,InterpolateLinear,Line,LineBasicMaterial,LineLoop,LineSegments,LinearFilter,LinearMipmapLinearFilter,LinearMipmapNearestFilter,LinearSRGBColorSpace,Loader,LoaderUtils,Material,MathUtils,Matrix4,Mesh,MeshBasicMaterial,MeshPhysicalMaterial,MeshStandardMaterial,MirroredRepeatWrapping,NearestFilter,NearestMipmapLinearFilter,NearestMipmapNearestFilter,NumberKeyframeTrack,Object3D,OrthographicCamera,PerspectiveCamera,PointLight,Points,PointsMaterial,PropertyBinding,Quaternion,QuaternionKeyframeTrack,RepeatWrapping,Skeleton,SkinnedMesh,Sphere,SpotLight,Texture,TextureLoader,TriangleFanDrawMode,TriangleStripDrawMode,Vector2,Vector3,VectorKeyframeTrack,SRGBColorSpace,InstancedBufferAttribute}from"three";import{toTrianglesDrawMode}from"../utils/BufferGeometryUtils.js";class GLTFLoader extends Loader{constructor(e){super(e),this.dracoLoader=null,this.ktx2Loader=null,this.meshoptDecoder=null,this.pluginCallbacks=[],this.register(function(e){return new GLTFMaterialsClearcoatExtension(e)}),this.register(function(e){return new GLTFMaterialsDispersionExtension(e)}),this.register(function(e){return new GLTFTextureBasisUExtension(e)}),this.register(function(e){return new GLTFTextureWebPExtension(e)}),this.register(function(e){return new GLTFTextureAVIFExtension(e)}),this.register(function(e){return new GLTFMaterialsSheenExtension(e)}),this.register(function(e){return new GLTFMaterialsTransmissionExtension(e)}),this.register(function(e){return new GLTFMaterialsVolumeExtension(e)}),this.register(function(e){return new GLTFMaterialsIorExtension(e)}),this.register(function(e){return new GLTFMaterialsEmissiveStrengthExtension(e)}),this.register(function(e){return new GLTFMaterialsSpecularExtension(e)}),this.register(function(e){return new GLTFMaterialsIridescenceExtension(e)}),this.register(function(e){return new GLTFMaterialsAnisotropyExtension(e)}),this.register(function(e){return new GLTFMaterialsBumpExtension(e)}),this.register(function(e){return new GLTFLightsExtension(e)}),this.register(function(e){return new GLTFMeshoptCompression(e)}),this.register(function(e){return new GLTFMeshGpuInstancing(e)})}load(e,t,s,n){const r=this;let i;if(""!==this.resourcePath)i=this.resourcePath;else if(""!==this.path){const t=LoaderUtils.extractUrlBase(e);i=LoaderUtils.resolveURL(t,this.path)}else i=LoaderUtils.extractUrlBase(e);this.manager.itemStart(e);const o=function(t){n&&n(t),r.manager.itemError(e),r.manager.itemEnd(e)},a=new FileLoader(this.manager);a.setPath(this.path),a.setResponseType("arraybuffer"),a.setRequestHeader(this.requestHeader),a.setWithCredentials(this.withCredentials),a.load(e,function(s){try{r.parse(s,i,function(s){t(s),r.manager.itemEnd(e)},o)}catch(e){o(e)}},s,o)}setDRACOLoader(e){return this.dracoLoader=e,this}setKTX2Loader(e){return this.ktx2Loader=e,this}setMeshoptDecoder(e){return this.meshoptDecoder=e,this}register(e){return-1===this.pluginCallbacks.indexOf(e)&&this.pluginCallbacks.push(e),this}unregister(e){return-1!==this.pluginCallbacks.indexOf(e)&&this.pluginCallbacks.splice(this.pluginCallbacks.indexOf(e),1),this}parse(e,t,s,n){let r;const i={},o={},a=new TextDecoder;if("string"==typeof e)r=JSON.parse(e);else if(e instanceof ArrayBuffer){if(a.decode(new Uint8Array(e,0,4))===BINARY_EXTENSION_HEADER_MAGIC){try{i[EXTENSIONS.KHR_BINARY_GLTF]=new GLTFBinaryExtension(e)}catch(e){return void(n&&n(e))}r=JSON.parse(i[EXTENSIONS.KHR_BINARY_GLTF].content)}else r=JSON.parse(a.decode(e))}else r=e;if(void 0===r.asset||r.asset.version[0]<2)return void(n&&n(new Error("THREE.GLTFLoader: Unsupported asset. glTF versions >=2.0 are supported.")));const c=new GLTFParser(r,{path:t||this.resourcePath||"",crossOrigin:this.crossOrigin,requestHeader:this.requestHeader,manager:this.manager,ktx2Loader:this.ktx2Loader,meshoptDecoder:this.meshoptDecoder});c.fileLoader.setRequestHeader(this.requestHeader);for(let e=0;e<this.pluginCallbacks.length;e++){const t=this.pluginCallbacks[e](c);t.name,o[t.name]=t,i[t.name]=1}if(r.extensionsUsed)for(let e=0;e<r.extensionsUsed.length;++e){const t=r.extensionsUsed[e],s=r.extensionsRequired||[];switch(t){case EXTENSIONS.KHR_MATERIALS_UNLIT:i[t]=new GLTFMaterialsUnlitExtension;break;case EXTENSIONS.KHR_DRACO_MESH_COMPRESSION:i[t]=new GLTFDracoMeshCompressionExtension(r,this.dracoLoader);break;case EXTENSIONS.KHR_TEXTURE_TRANSFORM:i[t]=new GLTFTextureTransformExtension;break;case EXTENSIONS.KHR_MESH_QUANTIZATION:i[t]=new GLTFMeshQuantizationExtension;break;default:s.indexOf(t)>=0&&o[t]}}c.setExtensions(i),c.setPlugins(o),c.parse(s,n)}parseAsync(e,t){const s=this;return new Promise(function(n,r){s.parse(e,t,n,r)})}}function GLTFRegistry(){let e={};return{get:function(t){return e[t]},add:function(t,s){e[t]=s},remove:function(t){delete e[t]},removeAll:function(){e={}}}}const EXTENSIONS={KHR_BINARY_GLTF:"KHR_binary_glTF",KHR_DRACO_MESH_COMPRESSION:"KHR_draco_mesh_compression",KHR_LIGHTS_PUNCTUAL:"KHR_lights_punctual",KHR_MATERIALS_CLEARCOAT:"KHR_materials_clearcoat",KHR_MATERIALS_DISPERSION:"KHR_materials_dispersion",KHR_MATERIALS_IOR:"KHR_materials_ior",KHR_MATERIALS_SHEEN:"KHR_materials_sheen",KHR_MATERIALS_SPECULAR:"KHR_materials_specular",KHR_MATERIALS_TRANSMISSION:"KHR_materials_transmission",KHR_MATERIALS_IRIDESCENCE:"KHR_materials_iridescence",KHR_MATERIALS_ANISOTROPY:"KHR_materials_anisotropy",KHR_MATERIALS_UNLIT:"KHR_materials_unlit",KHR_MATERIALS_VOLUME:"KHR_materials_volume",KHR_TEXTURE_BASISU:"KHR_texture_basisu",KHR_TEXTURE_TRANSFORM:"KHR_texture_transform",KHR_MESH_QUANTIZATION:"KHR_mesh_quantization",KHR_MATERIALS_EMISSIVE_STRENGTH:"KHR_materials_emissive_strength",EXT_MATERIALS_BUMP:"EXT_materials_bump",EXT_TEXTURE_WEBP:"EXT_texture_webp",EXT_TEXTURE_AVIF:"EXT_texture_avif",EXT_MESHOPT_COMPRESSION:"EXT_meshopt_compression",EXT_MESH_GPU_INSTANCING:"EXT_mesh_gpu_instancing"};class GLTFLightsExtension{constructor(e){this.parser=e,this.name=EXTENSIONS.KHR_LIGHTS_PUNCTUAL,this.cache={refs:{},uses:{}}}_markDefs(){const e=this.parser,t=this.parser.json.nodes||[];for(let s=0,n=t.length;s<n;s++){const n=t[s];n.extensions&&n.extensions[this.name]&&void 0!==n.extensions[this.name].light&&e._addNodeRef(this.cache,n.extensions[this.name].light)}}_loadLight(e){const t=this.parser,s="light:"+e;let n=t.cache.get(s);if(n)return n;const r=t.json,i=((r.extensions&&r.extensions[this.name]||{}).lights||[])[e];let o;const a=new Color(16777215);void 0!==i.color&&a.setRGB(i.color[0],i.color[1],i.color[2],LinearSRGBColorSpace);const c=void 0!==i.range?i.range:0;switch(i.type){case"directional":o=new DirectionalLight(a),o.target.position.set(0,0,-1),o.add(o.target);break;case"point":o=new PointLight(a),o.distance=c;break;case"spot":o=new SpotLight(a),o.distance=c,i.spot=i.spot||{},i.spot.innerConeAngle=void 0!==i.spot.innerConeAngle?i.spot.innerConeAngle:0,i.spot.outerConeAngle=void 0!==i.spot.outerConeAngle?i.spot.outerConeAngle:Math.PI/4,o.angle=i.spot.outerConeAngle,o.penumbra=1-i.spot.innerConeAngle/i.spot.outerConeAngle,o.target.position.set(0,0,-1),o.add(o.target);break;default:throw new Error("THREE.GLTFLoader: Unexpected light type: "+i.type)}return o.position.set(0,0,0),assignExtrasToUserData(o,i),void 0!==i.intensity&&(o.intensity=i.intensity),o.name=t.createUniqueName(i.name||"light_"+e),n=Promise.resolve(o),t.cache.add(s,n),n}getDependency(e,t){if("light"===e)return this._loadLight(t)}createNodeAttachment(e){const t=this,s=this.parser,n=s.json.nodes[e],r=(n.extensions&&n.extensions[this.name]||{}).light;return void 0===r?null:this._loadLight(r).then(function(e){return s._getNodeRef(t.cache,r,e)})}}class GLTFMaterialsUnlitExtension{constructor(){this.name=EXTENSIONS.KHR_MATERIALS_UNLIT}getMaterialType(){return MeshBasicMaterial}extendParams(e,t,s){const n=[];e.color=new Color(1,1,1),e.opacity=1;const r=t.pbrMetallicRoughness;if(r){if(Array.isArray(r.baseColorFactor)){const t=r.baseColorFactor;e.color.setRGB(t[0],t[1],t[2],LinearSRGBColorSpace),e.opacity=t[3]}void 0!==r.baseColorTexture&&n.push(s.assignTexture(e,"map",r.baseColorTexture,SRGBColorSpace))}return Promise.all(n)}}class GLTFMaterialsEmissiveStrengthExtension{constructor(e){this.parser=e,this.name=EXTENSIONS.KHR_MATERIALS_EMISSIVE_STRENGTH}extendMaterialParams(e,t){const s=this.parser.json.materials[e];if(!s.extensions||!s.extensions[this.name])return Promise.resolve();const n=s.extensions[this.name].emissiveStrength;return void 0!==n&&(t.emissiveIntensity=n),Promise.resolve()}}class GLTFMaterialsClearcoatExtension{constructor(e){this.parser=e,this.name=EXTENSIONS.KHR_MATERIALS_CLEARCOAT}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser,n=s.json.materials[e];if(!n.extensions||!n.extensions[this.name])return Promise.resolve();const r=[],i=n.extensions[this.name];if(void 0!==i.clearcoatFactor&&(t.clearcoat=i.clearcoatFactor),void 0!==i.clearcoatTexture&&r.push(s.assignTexture(t,"clearcoatMap",i.clearcoatTexture)),void 0!==i.clearcoatRoughnessFactor&&(t.clearcoatRoughness=i.clearcoatRoughnessFactor),void 0!==i.clearcoatRoughnessTexture&&r.push(s.assignTexture(t,"clearcoatRoughnessMap",i.clearcoatRoughnessTexture)),void 0!==i.clearcoatNormalTexture&&(r.push(s.assignTexture(t,"clearcoatNormalMap",i.clearcoatNormalTexture)),void 0!==i.clearcoatNormalTexture.scale)){const e=i.clearcoatNormalTexture.scale;t.clearcoatNormalScale=new Vector2(e,e)}return Promise.all(r)}}class GLTFMaterialsDispersionExtension{constructor(e){this.parser=e,this.name=EXTENSIONS.KHR_MATERIALS_DISPERSION}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser.json.materials[e];if(!s.extensions||!s.extensions[this.name])return Promise.resolve();const n=s.extensions[this.name];return t.dispersion=void 0!==n.dispersion?n.dispersion:0,Promise.resolve()}}class GLTFMaterialsIridescenceExtension{constructor(e){this.parser=e,this.name=EXTENSIONS.KHR_MATERIALS_IRIDESCENCE}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser,n=s.json.materials[e];if(!n.extensions||!n.extensions[this.name])return Promise.resolve();const r=[],i=n.extensions[this.name];return void 0!==i.iridescenceFactor&&(t.iridescence=i.iridescenceFactor),void 0!==i.iridescenceTexture&&r.push(s.assignTexture(t,"iridescenceMap",i.iridescenceTexture)),void 0!==i.iridescenceIor&&(t.iridescenceIOR=i.iridescenceIor),void 0===t.iridescenceThicknessRange&&(t.iridescenceThicknessRange=[100,400]),void 0!==i.iridescenceThicknessMinimum&&(t.iridescenceThicknessRange[0]=i.iridescenceThicknessMinimum),void 0!==i.iridescenceThicknessMaximum&&(t.iridescenceThicknessRange[1]=i.iridescenceThicknessMaximum),void 0!==i.iridescenceThicknessTexture&&r.push(s.assignTexture(t,"iridescenceThicknessMap",i.iridescenceThicknessTexture)),Promise.all(r)}}class GLTFMaterialsSheenExtension{constructor(e){this.parser=e,this.name=EXTENSIONS.KHR_MATERIALS_SHEEN}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser,n=s.json.materials[e];if(!n.extensions||!n.extensions[this.name])return Promise.resolve();const r=[];t.sheenColor=new Color(0,0,0),t.sheenRoughness=0,t.sheen=1;const i=n.extensions[this.name];if(void 0!==i.sheenColorFactor){const e=i.sheenColorFactor;t.sheenColor.setRGB(e[0],e[1],e[2],LinearSRGBColorSpace)}return void 0!==i.sheenRoughnessFactor&&(t.sheenRoughness=i.sheenRoughnessFactor),void 0!==i.sheenColorTexture&&r.push(s.assignTexture(t,"sheenColorMap",i.sheenColorTexture,SRGBColorSpace)),void 0!==i.sheenRoughnessTexture&&r.push(s.assignTexture(t,"sheenRoughnessMap",i.sheenRoughnessTexture)),Promise.all(r)}}class GLTFMaterialsTransmissionExtension{constructor(e){this.parser=e,this.name=EXTENSIONS.KHR_MATERIALS_TRANSMISSION}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser,n=s.json.materials[e];if(!n.extensions||!n.extensions[this.name])return Promise.resolve();const r=[],i=n.extensions[this.name];return void 0!==i.transmissionFactor&&(t.transmission=i.transmissionFactor),void 0!==i.transmissionTexture&&r.push(s.assignTexture(t,"transmissionMap",i.transmissionTexture)),Promise.all(r)}}class GLTFMaterialsVolumeExtension{constructor(e){this.parser=e,this.name=EXTENSIONS.KHR_MATERIALS_VOLUME}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser,n=s.json.materials[e];if(!n.extensions||!n.extensions[this.name])return Promise.resolve();const r=[],i=n.extensions[this.name];t.thickness=void 0!==i.thicknessFactor?i.thicknessFactor:0,void 0!==i.thicknessTexture&&r.push(s.assignTexture(t,"thicknessMap",i.thicknessTexture)),t.attenuationDistance=i.attenuationDistance||1/0;const o=i.attenuationColor||[1,1,1];return t.attenuationColor=(new Color).setRGB(o[0],o[1],o[2],LinearSRGBColorSpace),Promise.all(r)}}class GLTFMaterialsIorExtension{constructor(e){this.parser=e,this.name=EXTENSIONS.KHR_MATERIALS_IOR}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser.json.materials[e];if(!s.extensions||!s.extensions[this.name])return Promise.resolve();const n=s.extensions[this.name];return t.ior=void 0!==n.ior?n.ior:1.5,Promise.resolve()}}class GLTFMaterialsSpecularExtension{constructor(e){this.parser=e,this.name=EXTENSIONS.KHR_MATERIALS_SPECULAR}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser,n=s.json.materials[e];if(!n.extensions||!n.extensions[this.name])return Promise.resolve();const r=[],i=n.extensions[this.name];t.specularIntensity=void 0!==i.specularFactor?i.specularFactor:1,void 0!==i.specularTexture&&r.push(s.assignTexture(t,"specularIntensityMap",i.specularTexture));const o=i.specularColorFactor||[1,1,1];return t.specularColor=(new Color).setRGB(o[0],o[1],o[2],LinearSRGBColorSpace),void 0!==i.specularColorTexture&&r.push(s.assignTexture(t,"specularColorMap",i.specularColorTexture,SRGBColorSpace)),Promise.all(r)}}class GLTFMaterialsBumpExtension{constructor(e){this.parser=e,this.name=EXTENSIONS.EXT_MATERIALS_BUMP}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser,n=s.json.materials[e];if(!n.extensions||!n.extensions[this.name])return Promise.resolve();const r=[],i=n.extensions[this.name];return t.bumpScale=void 0!==i.bumpFactor?i.bumpFactor:1,void 0!==i.bumpTexture&&r.push(s.assignTexture(t,"bumpMap",i.bumpTexture)),Promise.all(r)}}class GLTFMaterialsAnisotropyExtension{constructor(e){this.parser=e,this.name=EXTENSIONS.KHR_MATERIALS_ANISOTROPY}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser,n=s.json.materials[e];if(!n.extensions||!n.extensions[this.name])return Promise.resolve();const r=[],i=n.extensions[this.name];return void 0!==i.anisotropyStrength&&(t.anisotropy=i.anisotropyStrength),void 0!==i.anisotropyRotation&&(t.anisotropyRotation=i.anisotropyRotation),void 0!==i.anisotropyTexture&&r.push(s.assignTexture(t,"anisotropyMap",i.anisotropyTexture)),Promise.all(r)}}class GLTFTextureBasisUExtension{constructor(e){this.parser=e,this.name=EXTENSIONS.KHR_TEXTURE_BASISU}loadTexture(e){const t=this.parser,s=t.json,n=s.textures[e];if(!n.extensions||!n.extensions[this.name])return null;const r=n.extensions[this.name],i=t.options.ktx2Loader;if(!i){if(s.extensionsRequired&&s.extensionsRequired.indexOf(this.name)>=0)throw new Error("THREE.GLTFLoader: setKTX2Loader must be called before loading KTX2 textures");return null}return t.loadTextureImage(e,r.source,i)}}class GLTFTextureWebPExtension{constructor(e){this.parser=e,this.name=EXTENSIONS.EXT_TEXTURE_WEBP}loadTexture(e){const t=this.name,s=this.parser,n=s.json,r=n.textures[e];if(!r.extensions||!r.extensions[t])return null;const i=r.extensions[t],o=n.images[i.source];let a=s.textureLoader;if(o.uri){const e=s.options.manager.getHandler(o.uri);null!==e&&(a=e)}return s.loadTextureImage(e,i.source,a)}}class GLTFTextureAVIFExtension{constructor(e){this.parser=e,this.name=EXTENSIONS.EXT_TEXTURE_AVIF}loadTexture(e){const t=this.name,s=this.parser,n=s.json,r=n.textures[e];if(!r.extensions||!r.extensions[t])return null;const i=r.extensions[t],o=n.images[i.source];let a=s.textureLoader;if(o.uri){const e=s.options.manager.getHandler(o.uri);null!==e&&(a=e)}return s.loadTextureImage(e,i.source,a)}}class GLTFMeshoptCompression{constructor(e){this.name=EXTENSIONS.EXT_MESHOPT_COMPRESSION,this.parser=e}loadBufferView(e){const t=this.parser.json,s=t.bufferViews[e];if(s.extensions&&s.extensions[this.name]){const e=s.extensions[this.name],n=this.parser.getDependency("buffer",e.buffer),r=this.parser.options.meshoptDecoder;if(!r||!r.supported){if(t.extensionsRequired&&t.extensionsRequired.indexOf(this.name)>=0)throw new Error("THREE.GLTFLoader: setMeshoptDecoder must be called before loading compressed files");return null}return n.then(function(t){const s=e.byteOffset||0,n=e.byteLength||0,i=e.count,o=e.byteStride,a=new Uint8Array(t,s,n);return r.decodeGltfBufferAsync?r.decodeGltfBufferAsync(i,o,a,e.mode,e.filter).then(function(e){return e.buffer}):r.ready.then(function(){const t=new ArrayBuffer(i*o);return r.decodeGltfBuffer(new Uint8Array(t),i,o,a,e.mode,e.filter),t})})}return null}}class GLTFMeshGpuInstancing{constructor(e){this.name=EXTENSIONS.EXT_MESH_GPU_INSTANCING,this.parser=e}createNodeMesh(e){const t=this.parser.json,s=t.nodes[e];if(!s.extensions||!s.extensions[this.name]||void 0===s.mesh)return null;const n=t.meshes[s.mesh];for(const e of n.primitives)if(e.mode!==WEBGL_CONSTANTS.TRIANGLES&&e.mode!==WEBGL_CONSTANTS.TRIANGLE_STRIP&&e.mode!==WEBGL_CONSTANTS.TRIANGLE_FAN&&void 0!==e.mode)return null;const r=s.extensions[this.name].attributes,i=[],o={};for(const e in r)i.push(this.parser.getDependency("accessor",r[e]).then(t=>(o[e]=t,o[e])));return i.length<1?null:(i.push(this.parser.createNodeMesh(e)),Promise.all(i).then(e=>{const t=e.pop(),s=t.isGroup?t.children:[t],n=e[0].count,r=[];for(const e of s){const t=new Matrix4,s=new Vector3,i=new Quaternion,a=new Vector3(1,1,1),c=new InstancedMesh(e.geometry,e.material,n);for(let e=0;e<n;e++)o.TRANSLATION&&s.fromBufferAttribute(o.TRANSLATION,e),o.ROTATION&&i.fromBufferAttribute(o.ROTATION,e),o.SCALE&&a.fromBufferAttribute(o.SCALE,e),c.setMatrixAt(e,t.compose(s,i,a));for(const t in o)if("_COLOR_0"===t){const e=o[t];c.instanceColor=new InstancedBufferAttribute(e.array,e.itemSize,e.normalized)}else"TRANSLATION"!==t&&"ROTATION"!==t&&"SCALE"!==t&&e.geometry.setAttribute(t,o[t]);Object3D.prototype.copy.call(c,e),this.parser.assignFinalMaterial(c),r.push(c)}return t.isGroup?(t.clear(),t.add(...r),t):r[0]}))}}const BINARY_EXTENSION_HEADER_MAGIC="glTF",BINARY_EXTENSION_HEADER_LENGTH=12,BINARY_EXTENSION_CHUNK_TYPES={JSON:1313821514,BIN:5130562};class GLTFBinaryExtension{constructor(e){this.name=EXTENSIONS.KHR_BINARY_GLTF,this.content=null,this.body=null;const t=new DataView(e,0,12),s=new TextDecoder;if(this.header={magic:s.decode(new Uint8Array(e.slice(0,4))),version:t.getUint32(4,1),length:t.getUint32(8,1)},this.header.magic!==BINARY_EXTENSION_HEADER_MAGIC)throw new Error("THREE.GLTFLoader: Unsupported glTF-Binary header.");if(this.header.version<2)throw new Error("THREE.GLTFLoader: Legacy binary file detected.");const n=this.header.length-12,r=new DataView(e,12);let i=0;for(;i<n;){const t=r.getUint32(i,1);i+=4;const n=r.getUint32(i,1);if(i+=4,n===BINARY_EXTENSION_CHUNK_TYPES.JSON){const n=new Uint8Array(e,12+i,t);this.content=s.decode(n)}else if(n===BINARY_EXTENSION_CHUNK_TYPES.BIN){const s=12+i;this.body=e.slice(s,s+t)}i+=t}if(null===this.content)throw new Error("THREE.GLTFLoader: JSON content not found.")}}class GLTFDracoMeshCompressionExtension{constructor(e,t){if(!t)throw new Error("THREE.GLTFLoader: No DRACOLoader instance provided.");this.name=EXTENSIONS.KHR_DRACO_MESH_COMPRESSION,this.json=e,this.dracoLoader=t,this.dracoLoader.preload()}decodePrimitive(e,t){const s=this.json,n=this.dracoLoader,r=e.extensions[this.name].bufferView,i=e.extensions[this.name].attributes,o={},a={},c={};for(const e in i){const t=ATTRIBUTES[e]||e.toLowerCase();o[t]=i[e]}for(const t in e.attributes){const n=ATTRIBUTES[t]||t.toLowerCase();if(void 0!==i[t]){const r=s.accessors[e.attributes[t]],i=WEBGL_COMPONENT_TYPES[r.componentType];c[n]=i.name,a[n]=1==r.normalized}}return t.getDependency("bufferView",r).then(function(e){return new Promise(function(t,s){n.decodeDracoFile(e,function(e){for(const t in e.attributes){const s=e.attributes[t],n=a[t];void 0!==n&&(s.normalized=n)}t(e)},o,c,LinearSRGBColorSpace,s)})})}}class GLTFTextureTransformExtension{constructor(){this.name=EXTENSIONS.KHR_TEXTURE_TRANSFORM}extendTexture(e,t){return void 0!==t.texCoord&&t.texCoord!==e.channel||void 0!==t.offset||void 0!==t.rotation||void 0!==t.scale?(e=e.clone(),void 0!==t.texCoord&&(e.channel=t.texCoord),void 0!==t.offset&&e.offset.fromArray(t.offset),void 0!==t.rotation&&(e.rotation=t.rotation),void 0!==t.scale&&e.repeat.fromArray(t.scale),e.needsUpdate=1,e):e}}class GLTFMeshQuantizationExtension{constructor(){this.name=EXTENSIONS.KHR_MESH_QUANTIZATION}}class GLTFCubicSplineInterpolant extends Interpolant{constructor(e,t,s,n){super(e,t,s,n)}copySampleValue_(e){const t=this.resultBuffer,s=this.sampleValues,n=this.valueSize,r=e*n*3+n;for(let e=0;e!==n;e++)t[e]=s[r+e];return t}interpolate_(e,t,s,n){const r=this.resultBuffer,i=this.sampleValues,o=this.valueSize,a=2*o,c=3*o,l=n-t,u=(s-t)/l,h=u*u,d=h*u,m=e*c,p=m-c,T=-2*d+3*h,f=d-h,E=1-T,g=f-h+u;for(let e=0;e!==o;e++){const t=i[p+e+o],s=i[p+e+a]*l,n=i[m+e+o],c=i[m+e]*l;r[e]=E*t+g*s+T*n+f*c}return r}}const _quaternion=new Quaternion;class GLTFCubicSplineQuaternionInterpolant extends GLTFCubicSplineInterpolant{interpolate_(e,t,s,n){const r=super.interpolate_(e,t,s,n);return _quaternion.fromArray(r).normalize().toArray(r),r}}const WEBGL_CONSTANTS={FLOAT:5126,FLOAT_MAT3:35675,FLOAT_MAT4:35676,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,LINEAR:9729,REPEAT:10497,SAMPLER_2D:35678,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,UNSIGNED_BYTE:5121,UNSIGNED_SHORT:5123},WEBGL_COMPONENT_TYPES={5120:Int8Array,5121:Uint8Array,5122:Int16Array,5123:Uint16Array,5125:Uint32Array,5126:Float32Array},WEBGL_FILTERS={9728:NearestFilter,9729:LinearFilter,9984:NearestMipmapNearestFilter,9985:LinearMipmapNearestFilter,9986:NearestMipmapLinearFilter,9987:LinearMipmapLinearFilter},WEBGL_WRAPPINGS={33071:ClampToEdgeWrapping,33648:MirroredRepeatWrapping,10497:RepeatWrapping},WEBGL_TYPE_SIZES={SCALAR:1,VEC2:2,VEC3:3,VEC4:4,MAT2:4,MAT3:9,MAT4:16},ATTRIBUTES={POSITION:"position",NORMAL:"normal",TANGENT:"tangent",TEXCOORD_0:"uv",TEXCOORD_1:"uv1",TEXCOORD_2:"uv2",TEXCOORD_3:"uv3",COLOR_0:"color",WEIGHTS_0:"skinWeight",JOINTS_0:"skinIndex"},PATH_PROPERTIES={scale:"scale",translation:"position",rotation:"quaternion",weights:"morphTargetInfluences"},INTERPOLATION={CUBICSPLINE:void 0,LINEAR:InterpolateLinear,STEP:InterpolateDiscrete},ALPHA_MODES={OPAQUE:"OPAQUE",MASK:"MASK",BLEND:"BLEND"};function createDefaultMaterial(e){return void 0===e.DefaultMaterial&&(e.DefaultMaterial=new MeshStandardMaterial({color:16777215,emissive:0,metalness:1,roughness:1,transparent:0,depthTest:1,side:FrontSide})),e.DefaultMaterial}function addUnknownExtensionsToUserData(e,t,s){for(const n in s.extensions)void 0===e[n]&&(t.userData.gltfExtensions=t.userData.gltfExtensions||{},t.userData.gltfExtensions[n]=s.extensions[n])}function assignExtrasToUserData(e,t){void 0!==t.extras&&"object"==typeof t.extras&&Object.assign(e.userData,t.extras)}function addMorphTargets(e,t,s){let n=0,r=0,i=0;for(let e=0,s=t.length;e<s;e++){const s=t[e];if(void 0!==s.POSITION&&(n=1),void 0!==s.NORMAL&&(r=1),void 0!==s.COLOR_0&&(i=1),n&&r&&i)break}if(!n&&!r&&!i)return Promise.resolve(e);const o=[],a=[],c=[];for(let l=0,u=t.length;l<u;l++){const u=t[l];if(n){const t=void 0!==u.POSITION?s.getDependency("accessor",u.POSITION):e.attributes.position;o.push(t)}if(r){const t=void 0!==u.NORMAL?s.getDependency("accessor",u.NORMAL):e.attributes.normal;a.push(t)}if(i){const t=void 0!==u.COLOR_0?s.getDependency("accessor",u.COLOR_0):e.attributes.color;c.push(t)}}return Promise.all([Promise.all(o),Promise.all(a),Promise.all(c)]).then(function(t){const s=t[0],o=t[1],a=t[2];return n&&(e.morphAttributes.position=s),r&&(e.morphAttributes.normal=o),i&&(e.morphAttributes.color=a),e.morphTargetsRelative=1,e})}function updateMorphTargets(e,t){if(e.updateMorphTargets(),void 0!==t.weights)for(let s=0,n=t.weights.length;s<n;s++)e.morphTargetInfluences[s]=t.weights[s];if(t.extras&&Array.isArray(t.extras.targetNames)){const s=t.extras.targetNames;if(e.morphTargetInfluences.length===s.length){e.morphTargetDictionary={};for(let t=0,n=s.length;t<n;t++)e.morphTargetDictionary[s[t]]=t}}}function createPrimitiveKey(e){let t;const s=e.extensions&&e.extensions[EXTENSIONS.KHR_DRACO_MESH_COMPRESSION];if(t=s?"draco:"+s.bufferView+":"+s.indices+":"+createAttributesKey(s.attributes):e.indices+":"+createAttributesKey(e.attributes)+":"+e.mode,void 0!==e.targets)for(let s=0,n=e.targets.length;s<n;s++)t+=":"+createAttributesKey(e.targets[s]);return t}function createAttributesKey(e){let t="";const s=Object.keys(e).sort();for(let n=0,r=s.length;n<r;n++)t+=s[n]+":"+e[s[n]]+";";return t}function getNormalizedComponentScale(e){switch(e){case Int8Array:return 1/127;case Uint8Array:return 1/255;case Int16Array:return 1/32767;case Uint16Array:return 1/65535;default:throw new Error("THREE.GLTFLoader: Unsupported normalized accessor component type.")}}function getImageURIMimeType(e){return e.search(/\.jpe?g($|\?)/i)>0||0===e.search(/^data\:image\/jpeg/)?"image/jpeg":e.search(/\.webp($|\?)/i)>0||0===e.search(/^data\:image\/webp/)?"image/webp":e.search(/\.ktx2($|\?)/i)>0||0===e.search(/^data\:image\/ktx2/)?"image/ktx2":"image/png"}const _identityMatrix=new Matrix4;class GLTFParser{constructor(e={},t={}){this.json=e,this.extensions={},this.plugins={},this.options=t,this.cache=new GLTFRegistry,this.associations=new Map,this.primitiveCache={},this.nodeCache={},this.meshCache={refs:{},uses:{}},this.cameraCache={refs:{},uses:{}},this.lightCache={refs:{},uses:{}},this.sourceCache={},this.textureCache={},this.nodeNamesUsed={};let s=0,n=-1,r=0,i=-1;if("undefined"!=typeof navigator){const e=navigator.userAgent;s=1==/^((?!chrome|android).)*safari/i.test(e);const t=e.match(/Version\/(\d+)/);n=s&&t?parseInt(t[1],10):-1,r=e.indexOf("Firefox")>-1,i=r?e.match(/Firefox\/([0-9]+)\./)[1]:-1}"undefined"==typeof createImageBitmap||s&&n<17||r&&i<98?this.textureLoader=new TextureLoader(this.options.manager):this.textureLoader=new ImageBitmapLoader(this.options.manager),this.textureLoader.setCrossOrigin(this.options.crossOrigin),this.textureLoader.setRequestHeader(this.options.requestHeader),this.fileLoader=new FileLoader(this.options.manager),this.fileLoader.setResponseType("arraybuffer"),"use-credentials"===this.options.crossOrigin&&this.fileLoader.setWithCredentials(1)}setExtensions(e){this.extensions=e}setPlugins(e){this.plugins=e}parse(e,t){const s=this,n=this.json,r=this.extensions;this.cache.removeAll(),this.nodeCache={},this._invokeAll(function(e){return e._markDefs&&e._markDefs()}),Promise.all(this._invokeAll(function(e){return e.beforeRoot&&e.beforeRoot()})).then(function(){return Promise.all([s.getDependencies("scene"),s.getDependencies("animation"),s.getDependencies("camera")])}).then(function(t){const i={scene:t[0][n.scene||0],scenes:t[0],animations:t[1],cameras:t[2],asset:n.asset,parser:s,userData:{}};return addUnknownExtensionsToUserData(r,i,n),assignExtrasToUserData(i,n),Promise.all(s._invokeAll(function(e){return e.afterRoot&&e.afterRoot(i)})).then(function(){for(const e of i.scenes)e.updateMatrixWorld();e(i)})}).catch(t)}_markDefs(){const e=this.json.nodes||[],t=this.json.skins||[],s=this.json.meshes||[];for(let s=0,n=t.length;s<n;s++){const n=t[s].joints;for(let t=0,s=n.length;t<s;t++)e[n[t]].isBone=1}for(let t=0,n=e.length;t<n;t++){const n=e[t];void 0!==n.mesh&&(this._addNodeRef(this.meshCache,n.mesh),void 0!==n.skin&&(s[n.mesh].isSkinnedMesh=1)),void 0!==n.camera&&this._addNodeRef(this.cameraCache,n.camera)}}_addNodeRef(e,t){void 0!==t&&(void 0===e.refs[t]&&(e.refs[t]=e.uses[t]=0),e.refs[t]++)}_getNodeRef(e,t,s){if(e.refs[t]<=1)return s;const n=s.clone(),r=(e,t)=>{const s=this.associations.get(e);null!=s&&this.associations.set(t,s);for(const[s,n]of e.children.entries())r(n,t.children[s])};return r(s,n),n.name+="_instance_"+e.uses[t]++,n}_invokeOne(e){const t=Object.values(this.plugins);t.push(this);for(let s=0;s<t.length;s++){const n=e(t[s]);if(n)return n}return null}_invokeAll(e){const t=Object.values(this.plugins);t.unshift(this);const s=[];for(let n=0;n<t.length;n++){const r=e(t[n]);r&&s.push(r)}return s}getDependency(e,t){const s=e+":"+t;let n=this.cache.get(s);if(!n){switch(e){case"scene":n=this.loadScene(t);break;case"node":n=this._invokeOne(function(e){return e.loadNode&&e.loadNode(t)});break;case"mesh":n=this._invokeOne(function(e){return e.loadMesh&&e.loadMesh(t)});break;case"accessor":n=this.loadAccessor(t);break;case"bufferView":n=this._invokeOne(function(e){return e.loadBufferView&&e.loadBufferView(t)});break;case"buffer":n=this.loadBuffer(t);break;case"material":n=this._invokeOne(function(e){return e.loadMaterial&&e.loadMaterial(t)});break;case"texture":n=this._invokeOne(function(e){return e.loadTexture&&e.loadTexture(t)});break;case"skin":n=this.loadSkin(t);break;case"animation":n=this._invokeOne(function(e){return e.loadAnimation&&e.loadAnimation(t)});break;case"camera":n=this.loadCamera(t);break;default:if(n=this._invokeOne(function(s){return s!=this&&s.getDependency&&s.getDependency(e,t)}),!n)throw new Error("Unknown type: "+e)}this.cache.add(s,n)}return n}getDependencies(e){let t=this.cache.get(e);if(!t){const s=this,n=this.json[e+("mesh"===e?"es":"s")]||[];t=Promise.all(n.map(function(t,n){return s.getDependency(e,n)})),this.cache.add(e,t)}return t}loadBuffer(e){const t=this.json.buffers[e],s=this.fileLoader;if(t.type&&"arraybuffer"!==t.type)throw new Error("THREE.GLTFLoader: "+t.type+" buffer type is not supported.");if(void 0===t.uri&&0===e)return Promise.resolve(this.extensions[EXTENSIONS.KHR_BINARY_GLTF].body);const n=this.options;return new Promise(function(e,r){s.load(LoaderUtils.resolveURL(t.uri,n.path),e,void 0,function(){r(new Error('THREE.GLTFLoader: Failed to load buffer "'+t.uri+'".'))})})}loadBufferView(e){const t=this.json.bufferViews[e];return this.getDependency("buffer",t.buffer).then(function(e){const s=t.byteLength||0,n=t.byteOffset||0;return e.slice(n,n+s)})}loadAccessor(e){const t=this,s=this.json,n=this.json.accessors[e];if(void 0===n.bufferView&&void 0===n.sparse){const e=WEBGL_TYPE_SIZES[n.type],t=WEBGL_COMPONENT_TYPES[n.componentType],s=1==n.normalized,r=new t(n.count*e);return Promise.resolve(new BufferAttribute(r,e,s))}const r=[];return void 0!==n.bufferView?r.push(this.getDependency("bufferView",n.bufferView)):r.push(null),void 0!==n.sparse&&(r.push(this.getDependency("bufferView",n.sparse.indices.bufferView)),r.push(this.getDependency("bufferView",n.sparse.values.bufferView))),Promise.all(r).then(function(e){const r=e[0],i=WEBGL_TYPE_SIZES[n.type],o=WEBGL_COMPONENT_TYPES[n.componentType],a=o.BYTES_PER_ELEMENT,c=a*i,l=n.byteOffset||0,u=void 0!==n.bufferView?s.bufferViews[n.bufferView].byteStride:void 0,h=1==n.normalized;let d,m;if(u&&u!==c){const e=Math.floor(l/u),s="InterleavedBuffer:"+n.bufferView+":"+n.componentType+":"+e+":"+n.count;let c=t.cache.get(s);c||(d=new o(r,e*u,n.count*u/a),c=new InterleavedBuffer(d,u/a),t.cache.add(s,c)),m=new InterleavedBufferAttribute(c,i,l%u/a,h)}else d=null===r?new o(n.count*i):new o(r,l,n.count*i),m=new BufferAttribute(d,i,h);if(void 0!==n.sparse){const t=WEBGL_TYPE_SIZES.SCALAR,s=WEBGL_COMPONENT_TYPES[n.sparse.indices.componentType],a=n.sparse.indices.byteOffset||0,c=n.sparse.values.byteOffset||0,l=new s(e[1],a,n.sparse.count*t),u=new o(e[2],c,n.sparse.count*i);null!==r&&(m=new BufferAttribute(m.array.slice(),m.itemSize,m.normalized)),m.normalized=0;for(let e=0,t=l.length;e<t;e++){const t=l[e];if(m.setX(t,u[e*i]),i>=2&&m.setY(t,u[e*i+1]),i>=3&&m.setZ(t,u[e*i+2]),i>=4&&m.setW(t,u[e*i+3]),i>=5)throw new Error("THREE.GLTFLoader: Unsupported itemSize in sparse BufferAttribute.")}m.normalized=h}return m})}loadTexture(e){const t=this.json,s=this.options,n=t.textures[e].source,r=t.images[n];let i=this.textureLoader;if(r.uri){const e=s.manager.getHandler(r.uri);null!==e&&(i=e)}return this.loadTextureImage(e,n,i)}loadTextureImage(e,t,s){const n=this,r=this.json,i=r.textures[e],o=r.images[t],a=(o.uri||o.bufferView)+":"+i.sampler;if(this.textureCache[a])return this.textureCache[a];const c=this.loadImageSource(t,s).then(function(t){t.flipY=0,t.name=i.name||o.name||"",""===t.name&&"string"==typeof o.uri&&0==o.uri.startsWith("data:image/")&&(t.name=o.uri);const s=(r.samplers||{})[i.sampler]||{};return t.magFilter=WEBGL_FILTERS[s.magFilter]||LinearFilter,t.minFilter=WEBGL_FILTERS[s.minFilter]||LinearMipmapLinearFilter,t.wrapS=WEBGL_WRAPPINGS[s.wrapS]||RepeatWrapping,t.wrapT=WEBGL_WRAPPINGS[s.wrapT]||RepeatWrapping,t.generateMipmaps=!t.isCompressedTexture&&t.minFilter!==NearestFilter&&t.minFilter!==LinearFilter,n.associations.set(t,{textures:e}),t}).catch(function(){return null});return this.textureCache[a]=c,c}loadImageSource(e,t){const s=this,n=this.json,r=this.options;if(void 0!==this.sourceCache[e])return this.sourceCache[e].then(e=>e.clone());const i=n.images[e],o=self.URL||self.webkitURL;let a=i.uri||"",c=0;if(void 0!==i.bufferView)a=s.getDependency("bufferView",i.bufferView).then(function(e){c=1;const t=new Blob([e],{type:i.mimeType});return a=o.createObjectURL(t),a});else if(void 0===i.uri)throw new Error("THREE.GLTFLoader: Image "+e+" is missing URI and bufferView");const l=Promise.resolve(a).then(function(e){return new Promise(function(s,n){let i=s;1==t.isImageBitmapLoader&&(i=function(e){const t=new Texture(e);t.needsUpdate=1,s(t)}),t.load(LoaderUtils.resolveURL(e,r.path),i,void 0,n)})}).then(function(e){return 1==c&&o.revokeObjectURL(a),assignExtrasToUserData(e,i),e.userData.mimeType=i.mimeType||getImageURIMimeType(i.uri),e}).catch(function(e){throw e});return this.sourceCache[e]=l,l}assignTexture(e,t,s,n){const r=this;return this.getDependency("texture",s.index).then(function(i){if(!i)return null;if(void 0!==s.texCoord&&s.texCoord>0&&((i=i.clone()).channel=s.texCoord),r.extensions[EXTENSIONS.KHR_TEXTURE_TRANSFORM]){const e=void 0!==s.extensions?s.extensions[EXTENSIONS.KHR_TEXTURE_TRANSFORM]:void 0;if(e){const t=r.associations.get(i);i=r.extensions[EXTENSIONS.KHR_TEXTURE_TRANSFORM].extendTexture(i,e),r.associations.set(i,t)}}return void 0!==n&&(i.colorSpace=n),e[t]=i,i})}assignFinalMaterial(e){const t=e.geometry;let s=e.material;const n=void 0===t.attributes.tangent,r=void 0!==t.attributes.color,i=void 0===t.attributes.normal;if(e.isPoints){const e="PointsMaterial:"+s.uuid;let t=this.cache.get(e);t||(t=new PointsMaterial,Material.prototype.copy.call(t,s),t.color.copy(s.color),t.map=s.map,t.sizeAttenuation=0,this.cache.add(e,t)),s=t}else if(e.isLine){const e="LineBasicMaterial:"+s.uuid;let t=this.cache.get(e);t||(t=new LineBasicMaterial,Material.prototype.copy.call(t,s),t.color.copy(s.color),t.map=s.map,this.cache.add(e,t)),s=t}if(n||r||i){let e="ClonedMaterial:"+s.uuid+":";n&&(e+="derivative-tangents:"),r&&(e+="vertex-colors:"),i&&(e+="flat-shading:");let t=this.cache.get(e);t||(t=s.clone(),r&&(t.vertexColors=1),i&&(t.flatShading=1),n&&(t.normalScale&&(t.normalScale.y*=-1),t.clearcoatNormalScale&&(t.clearcoatNormalScale.y*=-1)),this.cache.add(e,t),this.associations.set(t,this.associations.get(s))),s=t}e.material=s}getMaterialType(){return MeshStandardMaterial}loadMaterial(e){const t=this,s=this.json,n=this.extensions,r=s.materials[e];let i;const o={},a=[];if((r.extensions||{})[EXTENSIONS.KHR_MATERIALS_UNLIT]){const e=n[EXTENSIONS.KHR_MATERIALS_UNLIT];i=e.getMaterialType(),a.push(e.extendParams(o,r,t))}else{const s=r.pbrMetallicRoughness||{};if(o.color=new Color(1,1,1),o.opacity=1,Array.isArray(s.baseColorFactor)){const e=s.baseColorFactor;o.color.setRGB(e[0],e[1],e[2],LinearSRGBColorSpace),o.opacity=e[3]}void 0!==s.baseColorTexture&&a.push(t.assignTexture(o,"map",s.baseColorTexture,SRGBColorSpace)),o.metalness=void 0!==s.metallicFactor?s.metallicFactor:1,o.roughness=void 0!==s.roughnessFactor?s.roughnessFactor:1,void 0!==s.metallicRoughnessTexture&&(a.push(t.assignTexture(o,"metalnessMap",s.metallicRoughnessTexture)),a.push(t.assignTexture(o,"roughnessMap",s.metallicRoughnessTexture))),i=this._invokeOne(function(t){return t.getMaterialType&&t.getMaterialType(e)}),a.push(Promise.all(this._invokeAll(function(t){return t.extendMaterialParams&&t.extendMaterialParams(e,o)})))}1==r.doubleSided&&(o.side=DoubleSide);const c=r.alphaMode||ALPHA_MODES.OPAQUE;if(c===ALPHA_MODES.BLEND?(o.transparent=1,o.depthWrite=0):(o.transparent=0,c===ALPHA_MODES.MASK&&(o.alphaTest=void 0!==r.alphaCutoff?r.alphaCutoff:.5)),void 0!==r.normalTexture&&i!==MeshBasicMaterial&&(a.push(t.assignTexture(o,"normalMap",r.normalTexture)),o.normalScale=new Vector2(1,1),void 0!==r.normalTexture.scale)){const e=r.normalTexture.scale;o.normalScale.set(e,e)}if(void 0!==r.occlusionTexture&&i!==MeshBasicMaterial&&(a.push(t.assignTexture(o,"aoMap",r.occlusionTexture)),void 0!==r.occlusionTexture.strength&&(o.aoMapIntensity=r.occlusionTexture.strength)),void 0!==r.emissiveFactor&&i!==MeshBasicMaterial){const e=r.emissiveFactor;o.emissive=(new Color).setRGB(e[0],e[1],e[2],LinearSRGBColorSpace)}return void 0!==r.emissiveTexture&&i!==MeshBasicMaterial&&a.push(t.assignTexture(o,"emissiveMap",r.emissiveTexture,SRGBColorSpace)),Promise.all(a).then(function(){const s=new i(o);return r.name&&(s.name=r.name),assignExtrasToUserData(s,r),t.associations.set(s,{materials:e}),r.extensions&&addUnknownExtensionsToUserData(n,s,r),s})}createUniqueName(e){const t=PropertyBinding.sanitizeNodeName(e||"");return t in this.nodeNamesUsed?t+"_"+ ++this.nodeNamesUsed[t]:(this.nodeNamesUsed[t]=0,t)}loadGeometries(e){const t=this,s=this.extensions,n=this.primitiveCache;function r(e){return s[EXTENSIONS.KHR_DRACO_MESH_COMPRESSION].decodePrimitive(e,t).then(function(s){return addPrimitiveAttributes(s,e,t)})}const i=[];for(let s=0,o=e.length;s<o;s++){const o=e[s],a=createPrimitiveKey(o),c=n[a];if(c)i.push(c.promise);else{let e;e=o.extensions&&o.extensions[EXTENSIONS.KHR_DRACO_MESH_COMPRESSION]?r(o):addPrimitiveAttributes(new BufferGeometry,o,t),n[a]={primitive:o,promise:e},i.push(e)}}return Promise.all(i)}loadMesh(e){const t=this,s=this.json,n=this.extensions,r=s.meshes[e],i=r.primitives,o=[];for(let e=0,t=i.length;e<t;e++){const t=void 0===i[e].material?createDefaultMaterial(this.cache):this.getDependency("material",i[e].material);o.push(t)}return o.push(t.loadGeometries(i)),Promise.all(o).then(function(s){const o=s.slice(0,s.length-1),a=s[s.length-1],c=[];for(let s=0,l=a.length;s<l;s++){const l=a[s],u=i[s];let h;const d=o[s];if(u.mode===WEBGL_CONSTANTS.TRIANGLES||u.mode===WEBGL_CONSTANTS.TRIANGLE_STRIP||u.mode===WEBGL_CONSTANTS.TRIANGLE_FAN||void 0===u.mode)h=1==r.isSkinnedMesh?new SkinnedMesh(l,d):new Mesh(l,d),1==h.isSkinnedMesh&&h.normalizeSkinWeights(),u.mode===WEBGL_CONSTANTS.TRIANGLE_STRIP?h.geometry=toTrianglesDrawMode(h.geometry,TriangleStripDrawMode):u.mode===WEBGL_CONSTANTS.TRIANGLE_FAN&&(h.geometry=toTrianglesDrawMode(h.geometry,TriangleFanDrawMode));else if(u.mode===WEBGL_CONSTANTS.LINES)h=new LineSegments(l,d);else if(u.mode===WEBGL_CONSTANTS.LINE_STRIP)h=new Line(l,d);else if(u.mode===WEBGL_CONSTANTS.LINE_LOOP)h=new LineLoop(l,d);else{if(u.mode!==WEBGL_CONSTANTS.POINTS)throw new Error("THREE.GLTFLoader: Primitive mode unsupported: "+u.mode);h=new Points(l,d)}Object.keys(h.geometry.morphAttributes).length>0&&updateMorphTargets(h,r),h.name=t.createUniqueName(r.name||"mesh_"+e),assignExtrasToUserData(h,r),u.extensions&&addUnknownExtensionsToUserData(n,h,u),t.assignFinalMaterial(h),c.push(h)}for(let s=0,n=c.length;s<n;s++)t.associations.set(c[s],{meshes:e,primitives:s});if(1===c.length)return r.extensions&&addUnknownExtensionsToUserData(n,c[0],r),c[0];const l=new Group;r.extensions&&addUnknownExtensionsToUserData(n,l,r),t.associations.set(l,{meshes:e});for(let e=0,t=c.length;e<t;e++)l.add(c[e]);return l})}loadCamera(e){let t;const s=this.json.cameras[e],n=s[s.type];if(n)return"perspective"===s.type?t=new PerspectiveCamera(MathUtils.radToDeg(n.yfov),n.aspectRatio||1,n.znear||1,n.zfar||2e6):"orthographic"===s.type&&(t=new OrthographicCamera(-n.xmag,n.xmag,n.ymag,-n.ymag,n.znear,n.zfar)),s.name&&(t.name=this.createUniqueName(s.name)),assignExtrasToUserData(t,s),Promise.resolve(t)}loadSkin(e){const t=this.json.skins[e],s=[];for(let e=0,n=t.joints.length;e<n;e++)s.push(this._loadNodeShallow(t.joints[e]));return void 0!==t.inverseBindMatrices?s.push(this.getDependency("accessor",t.inverseBindMatrices)):s.push(null),Promise.all(s).then(function(e){const t=e.pop(),s=e,n=[],r=[];for(let e=0,i=s.length;e<i;e++){const i=s[e];if(i){n.push(i);const s=new Matrix4;null!==t&&s.fromArray(t.array,16*e),r.push(s)}}return new Skeleton(n,r)})}loadAnimation(e){const t=this.json,s=this,n=t.animations[e],r=n.name?n.name:"animation_"+e,i=[],o=[],a=[],c=[],l=[];for(let e=0,t=n.channels.length;e<t;e++){const t=n.channels[e],s=n.samplers[t.sampler],r=t.target,u=r.node,h=void 0!==n.parameters?n.parameters[s.input]:s.input,d=void 0!==n.parameters?n.parameters[s.output]:s.output;void 0!==r.node&&(i.push(this.getDependency("node",u)),o.push(this.getDependency("accessor",h)),a.push(this.getDependency("accessor",d)),c.push(s),l.push(r))}return Promise.all([Promise.all(i),Promise.all(o),Promise.all(a),Promise.all(c),Promise.all(l)]).then(function(e){const t=e[0],n=e[1],i=e[2],o=e[3],a=e[4],c=[];for(let e=0,r=t.length;e<r;e++){const r=t[e],l=n[e],u=i[e],h=o[e],d=a[e];if(void 0===r)continue;r.updateMatrix&&r.updateMatrix();const m=s._createAnimationTracks(r,l,u,h,d);if(m)for(let e=0;e<m.length;e++)c.push(m[e])}return new AnimationClip(r,void 0,c)})}createNodeMesh(e){const t=this.json,s=this,n=t.nodes[e];return void 0===n.mesh?null:s.getDependency("mesh",n.mesh).then(function(e){const t=s._getNodeRef(s.meshCache,n.mesh,e);return void 0!==n.weights&&t.traverse(function(e){if(e.isMesh)for(let t=0,s=n.weights.length;t<s;t++)e.morphTargetInfluences[t]=n.weights[t]}),t})}loadNode(e){const t=this,s=this.json.nodes[e],n=t._loadNodeShallow(e),r=[],i=s.children||[];for(let e=0,s=i.length;e<s;e++)r.push(t.getDependency("node",i[e]));const o=void 0===s.skin?Promise.resolve(null):t.getDependency("skin",s.skin);return Promise.all([n,Promise.all(r),o]).then(function(e){const t=e[0],s=e[1],n=e[2];null!==n&&t.traverse(function(e){e.isSkinnedMesh&&e.bind(n,_identityMatrix)});for(let e=0,n=s.length;e<n;e++)t.add(s[e]);return t})}_loadNodeShallow(e){const t=this.json,s=this.extensions,n=this;if(void 0!==this.nodeCache[e])return this.nodeCache[e];const r=t.nodes[e],i=r.name?n.createUniqueName(r.name):"",o=[],a=n._invokeOne(function(t){return t.createNodeMesh&&t.createNodeMesh(e)});return a&&o.push(a),void 0!==r.camera&&o.push(n.getDependency("camera",r.camera).then(function(e){return n._getNodeRef(n.cameraCache,r.camera,e)})),n._invokeAll(function(t){return t.createNodeAttachment&&t.createNodeAttachment(e)}).forEach(function(e){o.push(e)}),this.nodeCache[e]=Promise.all(o).then(function(t){let o;if(o=1==r.isBone?new Bone:t.length>1?new Group:1===t.length?t[0]:new Object3D,o!==t[0])for(let e=0,s=t.length;e<s;e++)o.add(t[e]);if(r.name&&(o.userData.name=r.name,o.name=i),assignExtrasToUserData(o,r),r.extensions&&addUnknownExtensionsToUserData(s,o,r),void 0!==r.matrix){const e=new Matrix4;e.fromArray(r.matrix),o.applyMatrix4(e)}else void 0!==r.translation&&o.position.fromArray(r.translation),void 0!==r.rotation&&o.quaternion.fromArray(r.rotation),void 0!==r.scale&&o.scale.fromArray(r.scale);if(n.associations.has(o)){if(void 0!==r.mesh&&n.meshCache.refs[r.mesh]>1){const e=n.associations.get(o);n.associations.set(o,{...e})}}else n.associations.set(o,{});return n.associations.get(o).nodes=e,o}),this.nodeCache[e]}loadScene(e){const t=this.extensions,s=this.json.scenes[e],n=this,r=new Group;s.name&&(r.name=n.createUniqueName(s.name)),assignExtrasToUserData(r,s),s.extensions&&addUnknownExtensionsToUserData(t,r,s);const i=s.nodes||[],o=[];for(let e=0,t=i.length;e<t;e++)o.push(n.getDependency("node",i[e]));return Promise.all(o).then(function(e){for(let t=0,s=e.length;t<s;t++)r.add(e[t]);return n.associations=(e=>{const t=new Map;for(const[e,s]of n.associations)(e instanceof Material||e instanceof Texture)&&t.set(e,s);return e.traverse(e=>{const s=n.associations.get(e);null!=s&&t.set(e,s)}),t})(r),r})}_createAnimationTracks(e,t,s,n,r){const i=[],o=e.name?e.name:e.uuid,a=[];let c;switch(PATH_PROPERTIES[r.path]===PATH_PROPERTIES.weights?e.traverse(function(e){e.morphTargetInfluences&&a.push(e.name?e.name:e.uuid)}):a.push(o),PATH_PROPERTIES[r.path]){case PATH_PROPERTIES.weights:c=NumberKeyframeTrack;break;case PATH_PROPERTIES.rotation:c=QuaternionKeyframeTrack;break;case PATH_PROPERTIES.translation:case PATH_PROPERTIES.scale:c=VectorKeyframeTrack;break;default:if(1===s.itemSize)c=NumberKeyframeTrack;else c=VectorKeyframeTrack}const l=void 0!==n.interpolation?INTERPOLATION[n.interpolation]:InterpolateLinear,u=this._getArrayFromAccessor(s);for(let e=0,s=a.length;e<s;e++){const s=new c(a[e]+"."+PATH_PROPERTIES[r.path],t.array,u,l);"CUBICSPLINE"===n.interpolation&&this._createCubicSplineTrackInterpolant(s),i.push(s)}return i}_getArrayFromAccessor(e){let t=e.array;if(e.normalized){const e=getNormalizedComponentScale(t.constructor),s=new Float32Array(t.length);for(let n=0,r=t.length;n<r;n++)s[n]=t[n]*e;t=s}return t}_createCubicSplineTrackInterpolant(e){e.createInterpolant=function(e){return new(this instanceof QuaternionKeyframeTrack?GLTFCubicSplineQuaternionInterpolant:GLTFCubicSplineInterpolant)(this.times,this.values,this.getValueSize()/3,e)},e.createInterpolant.isInterpolantFactoryMethodGLTFCubicSpline=1}}function computeBounds(e,t,s){const n=t.attributes,r=new Box3;if(void 0===n.POSITION)return;{const e=s.json.accessors[n.POSITION],t=e.min,i=e.max;if(void 0===t||void 0===i)return;if(r.set(new Vector3(t[0],t[1],t[2]),new Vector3(i[0],i[1],i[2])),e.normalized){const t=getNormalizedComponentScale(WEBGL_COMPONENT_TYPES[e.componentType]);r.min.multiplyScalar(t),r.max.multiplyScalar(t)}}const i=t.targets;if(void 0!==i){const e=new Vector3,t=new Vector3;for(let n=0,r=i.length;n<r;n++){const r=i[n];if(void 0!==r.POSITION){const n=s.json.accessors[r.POSITION],i=n.min,o=n.max;if(void 0!==i&&void 0!==o){if(t.setX(Math.max(Math.abs(i[0]),Math.abs(o[0]))),t.setY(Math.max(Math.abs(i[1]),Math.abs(o[1]))),t.setZ(Math.max(Math.abs(i[2]),Math.abs(o[2]))),n.normalized){const e=getNormalizedComponentScale(WEBGL_COMPONENT_TYPES[n.componentType]);t.multiplyScalar(e)}e.max(t)}}}r.expandByVector(e)}e.boundingBox=r;const o=new Sphere;r.getCenter(o.center),o.radius=r.min.distanceTo(r.max)/2,e.boundingSphere=o}function addPrimitiveAttributes(e,t,s){const n=t.attributes,r=[];function i(t,n){return s.getDependency("accessor",t).then(function(t){e.setAttribute(n,t)})}for(const t in n){const s=ATTRIBUTES[t]||t.toLowerCase();s in e.attributes||r.push(i(n[t],s))}if(void 0!==t.indices&&!e.index){const n=s.getDependency("accessor",t.indices).then(function(t){e.setIndex(t)});r.push(n)}return ColorManagement.workingColorSpace,assignExtrasToUserData(e,t),computeBounds(e,t,s),Promise.all(r).then(function(){return void 0!==t.targets?addMorphTargets(e,t.targets,s):e})}export{GLTFLoader};